% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTComPair.R
\name{ellipse.pv.rpv}
\alias{ellipse.pv.rpv}
\title{Elliptical joint confidence region for relative positive and
negative predictive value}
\usage{
ellipse.pv.rpv(x, alpha = 0.05, npoints = 100, exponentiate = FALSE)
}
\arguments{
\item{x}{an object returned by the \code{pv.rpv} function.}

\item{alpha}{significance level alpha used to compute the 100(1-alpha)\% region. The default is 0.05, for a 95\% region.}

\item{npoints}{the number of points used in the ellipse. Default is 100.}

\item{exponentiate}{a logical value indicating whether or not to exponentiate the values for the centre
of the ellipse and for the the ellipsoidal outline. Defaults to FALSE.}
}
\value{
A list containing:
\item{centre}{the centre of the ellipse.}
\item{ellipse}{an \code{npoints} x 2 matrix with the x and y coordinates for
the ellipsoidal outline. Suitable for \code{plot}-ing.}
}
\description{
Returns a 100(1-alpha)\% elliptical joint confidence region for the parameter
vector \{log(relative positive predictive value), log(relative negative predictive value)\}.
}
\examples{
data(Paired1) # Hypothetical study data
ftable(Paired1)
paired.layout <- tab.paired(d=d, y1=y1, y2=y2, data=Paired1)
paired.layout 
rpv.results <- pv.rpv(paired.layout)
ellipse.data <- ellipse.pv.rpv(rpv.results)
if(interactive()){
  plot(ellipse.data$ellipse, type = "l", ylim = c(-0.4, 0.2), xlim = c(-0.2, 0.2))
  points(ellipse.data$centre[1], ellipse.data$centre[2], col = "red", pch = 19)
  abline(h = 0, v = 0, lty = 3)
}

}
\references{
Moskowitz, C.S., and Pepe, M.S. (2006). Comparing the predictive values of diagnostic tests: sample size and analysis for paired study designs. \emph{Clin Trials}, 3(3):272-9.
}
\seealso{
\code{pv.rpv} and \code{ellipse::ellipse}.
}
