% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDTDAni.R
\name{plot.DTDAni}
\alias{plot.DTDAni}
\title{plot.DTDAni}
\usage{
\method{plot}{DTDAni}(x, ecdf = FALSE, ...)
}
\arguments{
\item{x}{DTDAni object.}

\item{ecdf}{Whether to display the ordinary empirical cumulative distribution function or not. Default = FALSE.}

\item{...}{Aditional parameters.}
}
\description{
S3 method to plot a DTDAni object by using the generic plot function.
}
\section{Acknowledgements}{

\itemize{
\item{Jacobo de Uña-Álvarez was supported by Grant MTM2014-55966-P, Spanish Ministry of Economy and Competitiveness.}
\item{José Carlos Soage was supported by Red Tecnológica de Matemática Industrial (Red TMATI), Cons. de Cultura, Educación e OU, Xunta de Galicia (ED341D R2016/051) and by Grupos de Referencia Competitiva, Consolidación y Estructuración de Unidades de Investigación Competitivas del SUG, Cons. de Cultura, Educación e OU, Xunta de Galicia (GRC ED431C 2016/040).}
}
}

\examples{

\dontrun{
N <- 250
x0 <- runif(N)             # Original data
u0 <- runif(N, -0.25, 0.5) # Left-truncation times
tau <- 0.75                # Interval width
v0 <- u0 + tau

x <- x0[u0 <= x0 & x0 <= v0]
u <- u0[u0 <= x0 & x0 <= v0]
v <- v0[u0 <= x0 & x0 <= v0]
n <- length(x)  # Final sample size after the interval sampling
res <- DTDAni(x, u , tau)
plot(res)
plot(res, ecdf = TRUE)
}

}
\references{
de Uña-Álvarez J. (2018) A Non-iterative Estimator for Interval Sampling and
Doubly Truncated Data. In: Gil E., Gil E., Gil J., Gil M. (eds)
The Mathematics of the Uncertain. Studies in Systems, Decision and Control,
vol 142. Springer, Cham, pp. 387-400.
}
\author{
\itemize{
\item{de Uña-Álvarez, Jacobo.}
\item{Soage González, José Carlos.}
\item{Maintainer: José Carlos Soage González. \email{jsoage@uvigo.es}}
}
}
