% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Datastream.R
\name{DataClient}
\alias{DataClient}
\title{DataClient}
\value{
DataClient object
}
\description{
An RC class for accessing Datastream content through Datastream Web services API
}
\examples{

## ------------------------------------------------
## Method `DataClient$new`
## ------------------------------------------------

\dontrun{
 # ds = DataClient$new(NULL, "YourID", "YourPswd")

 #  OR

 # Login using config file
 # Config file details provided in DSConnect.R
 ds = DataClient("Config.ini")

 # Timeseries requests

 df = tryCatch (
   {ds$getData(tickers="VOD", fields=list("PH","PL"),
               start='2022-01-12', end='2022-07-13', kind=1)},
   error = function(e) { stop (message(e))})
   print(df)

 # Snapshot requests

 df = tryCatch (
 { ds$getData(tickers="VOD", fields=list("PH", "PL"),
              start='2022-01-12', kind=0)},
 error = function(e) { stop (message(e))})
 print(df)
}


}
\section{Super class}{
\code{\link[DatastreamR:DSConnect]{DatastreamR::DSConnect}} -> \code{DataClient}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{useNaNforNotANumber}}{: TRUE by default. NULLs are replaced to NaN (Not a Number)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataClient-new}{\code{DataClient$new()}}
\item \href{#method-DataClient-getData}{\code{DataClient$getData()}}
\item \href{#method-DataClient-getDataframe}{\code{DataClient$getDataframe()}}
\item \href{#method-DataClient-formatDataRequest}{\code{DataClient$formatDataRequest()}}
\item \href{#method-DataClient-getDataBundle}{\code{DataClient$getDataBundle()}}
\item \href{#method-DataClient-toDataframe}{\code{DataClient$toDataframe()}}
\item \href{#method-DataClient-clone}{\code{DataClient$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="CheckToken"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-CheckToken'><code>DatastreamR::DSConnect$CheckToken()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="IsValid"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-IsValid'><code>DatastreamR::DSConnect$IsValid()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="getJsonResponse"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-getJsonResponse'><code>DatastreamR::DSConnect$getJsonResponse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="DatastreamR" data-topic="DSConnect" data-id="getToken"><a href='../../DatastreamR/html/DSConnect.html#method-DSConnect-getToken'><code>DatastreamR::DSConnect$getToken()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-new}{}}}
\subsection{Method \code{new()}}{
Initialize method to create Datastream Object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$new(
  config = NULL,
  username = "",
  password = "",
  proxys = NULL,
  sslCer = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{: Config path}

\item{\code{username}}{: Your Id}

\item{\code{password}}{: Your Password}

\item{\code{proxys}}{: Proxy details (if any)}

\item{\code{sslCer}}{: ssl Certificates path}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Creates Datastream RC object for accessing Datastream content
through Datastream Web Services API
}

\subsection{Returns}{
DataClient object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # ds = DataClient$new(NULL, "YourID", "YourPswd")

 #  OR

 # Login using config file
 # Config file details provided in DSConnect.R
 ds = DataClient("Config.ini")

 # Timeseries requests

 df = tryCatch (
   {ds$getData(tickers="VOD", fields=list("PH","PL"),
               start='2022-01-12', end='2022-07-13', kind=1)},
   error = function(e) { stop (message(e))})
   print(df)

 # Snapshot requests

 df = tryCatch (
 { ds$getData(tickers="VOD", fields=list("PH", "PL"),
              start='2022-01-12', kind=0)},
 error = function(e) { stop (message(e))})
 print(df)
}


}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-getData"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-getData}{}}}
\subsection{Method \code{getData()}}{
getData posts the JSON formatted request and the JSON response is
then converted to Dataframe, if dataToDF is TRUE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$getData(
  tickers,
  fields = NULL,
  start = "",
  end = "",
  freq = "D",
  kind = 1,
  properties = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tickers}}{: Intruments Eg: "VOD,BARC"}

\item{\code{fields}}{: Datatypes   Eg: list('PH, 'PL', 'PI')}

\item{\code{start}}{: start date in "YYYY-mm-dd" format Eg: "2019-01-20"}

\item{\code{end}}{: end date  in}

\item{\code{freq}}{: Refer DSDateFrequencyNames in DSRequests.R}

\item{\code{kind}}{: 1 - TimeSeries Request (default), 0 - Snapshot Request}

\item{\code{properties}}{: properties}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response Class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-getDataframe"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-getDataframe}{}}}
\subsection{Method \code{getDataframe()}}{
getDataframe posts the JSON formatted request and the JSON response is
then converted to Dataframe
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$getDataframe(
  tickers,
  fields = NULL,
  start = "",
  end = "",
  freq = "D",
  kind = 1,
  properties = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tickers}}{: Intruments Eg: "VOD,BARC"}

\item{\code{fields}}{: Datatypes   Eg: list('PH, 'PL', 'PI')}

\item{\code{start}}{: start date in "YYYY-mm-dd" format Eg: "2019-01-20"}

\item{\code{end}}{: end date  in}

\item{\code{freq}}{: Refer DSDateFrequencyNames in DSRequests.R}

\item{\code{kind}}{: 1 - TimeSeries Request (default), 0 - Snapshot Request}

\item{\code{properties}}{: properties}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-formatDataRequest"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-formatDataRequest}{}}}
\subsection{Method \code{formatDataRequest()}}{
This method formats the request provided by client (in form of tickers and fields)
to the JSON formatted request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$formatDataRequest(
  tickers,
  fields = NULL,
  start = "",
  end = "",
  freq = "D",
  kind = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tickers}}{: Instruments}

\item{\code{fields}}{: Datatypes}

\item{\code{start}}{: start date}

\item{\code{end}}{: end date}

\item{\code{freq}}{: frequency}

\item{\code{kind}}{: kind = 0 for Snapshot request and Kind = 1 for Timeseries request}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
JSON formatted data request
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-getDataBundle"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-getDataBundle}{}}}
\subsection{Method \code{getDataBundle()}}{
getData posts the JSON formatted request and the JSON response is
then converted to Dataframe, if dataToDF is TRUE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$getDataBundle(dataRequests, properties = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataRequests}}{: dataRequests should be formed using formatDataRequest method}

\item{\code{properties}}{: properties}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response Class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-toDataframe"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-toDataframe}{}}}
\subsection{Method \code{toDataframe()}}{
Converts the Class response into a Dataframe which can be further used to plot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$toDataframe(dataResponse)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataResponse}}{: The raw data response that is ingested into Dataframe}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Dataframe
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
