% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_edit.R
\name{modify_edit}
\alias{modify_edit}
\title{Modify internal variables in a design}
\usage{
modify_edit(design, ...)
}
\arguments{
\item{design}{A design object created by DeclareDesign.}

\item{...}{Named variable updates (e.g., \code{N = 20}, \code{b = 0.5}).}
}
\value{
A design with updated variables.
}
\description{
Internal helper for \code{redesign()}. Updates variable values inside quosure environments
of a design object so that rerunning the design reflects new inputs.
}
\examples{
n <- 2
b <- 1
d <- declare_model(N = n, Y = rnorm(N, b)) + declare_inquiry(Q = b)
d2 <- redesign(d, n = 3, b = 0.2)
draw_data(d2)
}
\keyword{internal}
