% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SumCI.R
\name{SumCI}
\alias{SumCI}
\title{Add Up Partial Confidence Intervals to a Total CI}
\usage{
SumCI(x)
}
\arguments{
\item{x}{a matrix with 3 columns, containing the estimate in the first column
followed by the lower and the upper confidence interval .}
}
\value{
a vector with the sum and the lower, upper confidence
bound of the confidence interval
}
\description{
Starting with a response variable that obtains different
confidence intervals (CI) when calculated with different
explanatory variables, all the values of the response variable
should be added up. This function returns the CI for the sum.
}
\examples{
x <- do.call(rbind, 
             tapply(d.pizza$delivery_min, 
                    d.pizza$area, MeanCI))
SumCI(x)

}
\references{
\url{https://stats.stackexchange.com/questions/223924/how-to-add-up-partial-confidence-intervals-to-create-a-total-confidence-interval}
}
\seealso{
\code{\link{BinomCI}},
}
\author{
Andri Signorell \href{mailto:andri@signorell.net}{andri@signorell.net}
}
