% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eng_dynare.R
\name{eng_dynare}
\alias{eng_dynare}
\title{DynareR: A Seamless Integration of R and Dynare}
\usage{
eng_dynare(options)
}
\arguments{
\item{options}{Chunk options, as provided by \code{knitr} during chunk execution. Chunk option for this is \code{dynare}}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) codes
}
\description{
This package runs on top of knitr to facilitate communication with Dynare. Run Dynare scripts from R Markdown document.
}
\details{
The \code{dynare} engine can be activated via

\if{html}{\out{<div class="sourceCode">}}\preformatted{knitr::knit_engines$set(dynare = DynareR::eng_dynare)
}\if{html}{\out{</div>}}

This will be set within an R Markdown document's setup chunk.
}
\examples{
knitr::knit_engines$set(dynare = DynareR::eng_dynare)
library(DynareR)
}
\references{
Mati S. 2020a. “DynareR: Bringing the Power of Dynare to R, R Markdown, and Quarto.” CRAN. https://CRAN.R-project.org/package=DynareR.

Mati S. 2020b. EviewsR: A Seamless Integration of EViews and R. \url{https://CRAN.R-project.org/package=EviewsR}.

Mati S. 2020c. gretlR: A Seamless Integration of Gretl and R. \url{https://CRAN.R-project.org/package=gretlR}.

Mati S. 2023a. URooTab: Tabular Reporting of EViews Unit Root Tests. \url{https://CRAN.R-project.org/package=URooTab}.

Mati S, Civcir I., and Abba S. I. 2023. “EviewsR: An r Package for Dynamic and Reproducible Research Using EViews, r, r Markdown and Quarto.” The R Journal 15 (2): 169–205. \doi{10.32614/rj-2023-045}.

Bob Rudis (2015).Running Go language chunks in R Markdown (Rmd) files. Available at:  https://gist.github.com/hrbrmstr/9accf90e63d852337cb7

Yihui Xie (2019). knitr: A General-Purpose Package for Dynamic Report Generation in R. R package version 1.24.

Yihui Xie (2015) Dynamic Documents with R and knitr. 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963

Yihui Xie (2014) knitr: A Comprehensive Tool for Reproducible Research in R. In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595
}
\seealso{
Other important functions: 
\code{\link{DynareR-package}},
\code{\link{add_matlab_path}()},
\code{\link{add_path}()},
\code{\link{import_log}()},
\code{\link{include_IRF}()},
\code{\link{input_tex}()},
\code{\link{run_dynare}()},
\code{\link{run_models}()},
\code{\link{set_dynare_version}()},
\code{\link{set_matlab_path}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\author{
Sagiru Mati, ORCID: 0000-0003-1413-3974, https://smati.com.ng
\itemize{
\item Yusuf Maitama Sule (Northwest) University Kano, Nigeria
\item SMATI Academy
}
}
\concept{important functions}
\keyword{documentation}
