% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cont_to_disc_V.R
\name{cont_to_disc_V}
\alias{cont_to_disc_V}
\title{Convert data to V statistic}
\usage{
cont_to_disc_V(ICdata, OCdata, var.p = NULL)
}
\arguments{
\item{ICdata}{The in-control data.}

\item{OCdata}{The out-of-control data.}

\item{var.p}{Variance of the random variables in the in-control data.}
}
\value{
\code{V0}\eqn{\hspace{2cm}} The V statistic for in-control data.

\code{V1}\eqn{\hspace{2cm}} The V statistic for out-of-control data.

\code{p0}\eqn{\hspace{2cm}} The process proportion for in-control data.

\code{p1}\eqn{\hspace{2cm}} The process proportion for out-of-control data.

\code{n}\eqn{\hspace{2.2cm}} The number of the sample size.
}
\description{
Convert continuous random variables in in-control process to discrete data with V statistic, where V statistic is the total number of sample satisfying \eqn{Y_{ij}=\frac{(X_{i2j}-X_{i(2j-1)})^2}{2}>\sigma^2} at time \eqn{i},
where \eqn{X_{ij}} is the observation for the \eqn{i^{th}} sampling period and the \eqn{j^{th}} sample in the in-control data, \eqn{n} is the number of the sample size and \eqn{m} is the number of the sampling periods.
\eqn{\sigma^2} is population variance of continuous in-control data. If \eqn{\sigma^2} is unknown, it can be estimated by \eqn{\hat{\sigma}^2 = \frac{\sum^m_{i=1}S_i^2}{m}} and \eqn{S_i^2 = \frac{\sum^n_{j=1}(X_{ij}-\overline{X}_i)^2}{n-1}}.
}
\examples{
IC = matrix(rnorm(100,0,1),ncol = 10,byrow = TRUE)
OC = matrix(rnorm(100,0,2),ncol = 10,byrow = TRUE)
cont_to_disc_V(IC,OC)
}
\references{
Yang, S. F. & Arnold, B. C. (2014). A simple approach for monitoring business service time variation.\emph{The Scientific World Journal}, \emph{2014}:16.

Yang, S. F., & Arnold, B. C. (2016). A new approach for monitoring process variance. \emph{Journal of Statistical Computation and Simulation}, \emph{86(14)}, 2749-2765.
}
