% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prucka.R
\name{prucka}
\alias{prucka}
\alias{read_prucka}
\alias{read_prucka_header}
\alias{read_prucka_signal}
\title{Read Prucka System Files}
\usage{
read_prucka(signal_file, header_file = NULL, n = Inf)

read_prucka_header(header_file)

read_prucka_signal(signal_file, n = Inf)
}
\arguments{
\item{signal_file}{Path to the *.txt signal data file}

\item{header_file}{Path to the *.inf header file. If NULL, will look for a
file with the same base name as signal_file but with .inf extension.}

\item{n}{Number of signal values to return (this will be the same for each
channel of data). Defaults to all values.}
}
\value{
An \code{egm} class object that is a list of EP signals the format of a
\code{data.table}, with an attached \strong{header} attribute that contains
additional recording data.
}
\description{
\code{read_prucka()} reads both the signal data (\emph{.txt) and header information
(}.inf) exported from the Prucka cardiac electrophysiology system, which is
the underlying recording software used in GE Healthcare's CardioLab EP
system.
}
\details{
\subsection{Exporting from GE CardioLab/Prucka}{

To export data from the GE CardioLab system:
\enumerate{
\item Open the study/recording in CardioLab
\item Select the time segment you want to export
\item Navigate to \strong{File > Export} or \strong{Tools > Export}
\item Choose \strong{ASCII Export} or \strong{Text Export} format
\item Select the channels to export
\item Choose export location and filename
\item The system will create two files:
\itemize{
\item \strong{X####.txt}: Space-delimited signal data
\item \strong{X####.inf}: Header file with metadata
}
}
}

\subsection{File Format Details}{

\strong{Signal file (*.txt)}:
\itemize{
\item Space-delimited numeric data
\item Each row represents one time point
\item First column: sample index/time marker
\item Subsequent columns: channel data in mV
\item All channels sampled at the same rate
}

\strong{Header file (*.inf)}:
\itemize{
\item Key-value pairs with "=" delimiter
\item Patient information (name, date, description)
\item Recording parameters (sampling rate, duration, channel count)
\item Channel mapping section listing channel numbers and labels
\item Channel numbers may be non-sequential (e.g., 1-12, 49-50, 75-76)
}

Both files must have the same base name (e.g., X001.txt and X001.inf).
}

\subsection{Notes}{
\itemize{
\item Default units are mV for electrical signals and mmHg for pressure
\item The system typically uses 16-bit ADC resolution
\item Channel labels may include surface ECG leads (I, II, III, aVR, aVL, aVF,
V1-V6) and intracardiac catheters (ABL, His, CS, RV, etc.)
\item Export may be limited by system memory for very long recordings
}
}
}
