% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_nonpar.R
\name{test_nonpar}
\alias{test_nonpar}
\title{Non-inferiority and equivalence test for the difference of two Kaplan-Meier curves}
\usage{
test_nonpar(epsilon, alpha, t0, type, data_r, data_t, plot = TRUE)
}
\arguments{
\item{epsilon}{non-inferiority/equivalence margin}

\item{alpha}{significance level}

\item{t0}{time point of interest}

\item{type}{type of the test. "ni" for non-inferiority, "eq" for equivalence test}

\item{data_r, data_t}{datasets containing time and status for each individual}

\item{plot}{if TRUE, a plot of the two Kaplan Meier curves will be given}
}
\value{
A list containing the difference \eqn{S_1(t_0)-S_2(t_0)}, the lower and upper (1-\eqn{\alpha})-confidence bounds, the chosen margin and significance level and the test decision. Further a plot of the curves is given.
}
\description{
Function for fitting and testing two Kaplan Meier curves \eqn{S_1}, \eqn{S_2} at \eqn{t_0} concerning the
hypotheses of non-inferiority \deqn{H_0:S_1(t_0)-S_2(t_0)\geq \epsilon\ vs.\ H_1: S_1(t_0)-S_2(t_0)< \epsilon}
or equivalence \deqn{H_0:|S_1(t_0)-S_2(t_0)|\geq \epsilon\ vs.\ H_1: |S_1(t_0)-S_2(t_0)|< \epsilon.}
}
\examples{
data(veteran)
veteran_r <- veteran[veteran$trt==1,]
veteran_t <- veteran[veteran$trt==2,]
alpha<-0.05
t0<-80
epsilon<-0.15
test_nonpar(epsilon=epsilon,alpha=alpha,t0=t0,type="eq",data_r=veteran_r,data_t=veteran_t)
}
