% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq.evaluate.core.R
\name{qq.evaluate.core}
\alias{qq.evaluate.core}
\title{Quantile-Quantile Plots}
\usage{
qq.evaluate.core(
  data,
  names,
  quantitative,
  selected,
  annotate = c("none", "kl", "ks", "ad"),
  show.count = FALSE
)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}

\item{annotate}{Adds the divergence/distance value between probability
distributions of CS and EC as an annotation to the QQ plot. Either
\code{"none"} (no annotation (Default)) or \code{"kl"} (Kullback-Leibler
divergence) or  \code{"ks"} (Kolmogorov-Smirnov distance) or  \code{"ad"}
(Anderson-Darling distance).}

\item{show.count}{logical. If \code{TRUE}, the accession count excluding
missing values will also be displayed. Default is \code{FALSE}.}
}
\value{
A list with the \code{ggplot} objects of QQ plots of CS vs EC for
  each trait specified as \code{quantitative}.
}
\description{
Plot Quantile-Quantile (QQ) plots
\insertCite{wilk_probability_1968}{EvaluateCore} to graphically compare the
probability distributions of quantitative traits between entire collection
(EC) and core set (CS).
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

\donttest{
qq.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core)

qq.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core, show.count = TRUE)

qq.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core, annotate = "kl")

qq.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core, annotate = "ks")

qq.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core, annotate = "ad")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats:qqnorm]{qqplot}} \code{\link[entropy]{KL.plugin}},
  \code{\link[stats]{ks.test}}, \code{\link[kSamples]{ad.test}},
  \code{\link[EvaluateCore]{pdfdist.evaluate.core}}
}
