\name{ExactCox}
\alias{ExactCox}
\title{
Exact Test and exact Confidence Interval for the Cox Model
}
\description{
Performs the exact test on whether there is a difference between two survival curves.  Exact confidence interval for the hazard ratio can also be generated if treatment is the only fixed effect in the Cox model.
}
\usage{
ExactCox(time, status, trt, hr = 1, alternative = "two.sided", conf.int = FALSE,
    conf.level = 0.95)
}
\arguments{
  \item{time}{
Time of the event or censoring.
}
  \item{status}{
a binary variable indicating whether the record is an event or is censored.  1 is for event, 0 is for censoring.
}
  \item{trt}{
a binary treatment group.
}
  \item{hr}{
the hypothesized hazard ratio.
}
  \item{alternative}{
indicates the alternative hypothesis and must be one of "two.sided", "greater" or "less".
}
  \item{conf.int}{
logical indicating if a confidence interval for the hazard ratio should be computed (and returned).
}
  \item{conf.level}{
confidence level for the returned confidence interval.  Only used if conf.int = TRUE.
}
}
\details{
The exact p-value is generated based on the conditional error method.  The exact confidence interval is generated by inverting the exact test.  See Shao, Ye and Zhang (2024) for details.
}
\value{
  \item{p.value}{
the p-value of the exact test.
}
  \item{conf.int}{
the exact confidence interval.
}
  \item{alternative}{
a character string describing the alternative hypothesis.
}
}
\references{
Shao, Y., Ye, Z. and Zhang, Z. (2024).  Exact test and exact confidence interval for the Cox model.  Submitted.
}
\author{
Yongwu Shao
}
\examples{
## Creating example data
N = 100;
futime = rexp(N)
fustat = rbinom(N, 1, 0.2)
rx = rbinom(N, 1, 0.5)
## Calculate the exact p-value and the exact confidence interval.
ExactCox(futime, fustat, rx, hr = 1, alternative = 'less', conf.int = TRUE)
}
