% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{lr_ind_dist}
\alias{lr_ind_dist}
\title{Exact LR_ind distribution (auto‑select engine)}
\usage{
lr_ind_dist(n, alpha = 0.05, prune_threshold = 1e-15)
}
\arguments{
\item{n}{Integer sample size (\eqn{n \ge 1}).}

\item{alpha}{Exception probability \eqn{\alpha \in (0,1)}.}

\item{prune_threshold}{Probability below which states are pruned by the
dynamic‑programming recursion.}
}
\value{
A named list with elements \code{LR} and \code{prob} of equal length,
where \code{LR} is the support of the LR statistic and \code{prob} are the
corresponding probabilities in \eqn{[0,1]} that sum to 1.
}
\description{
Returns the finite‑sample distribution of Christoffersen’s independence
statistic \eqn{LR_{\mathrm{ind}}}.
}
\examples{
lr_ind_dist(8, 0.05)
}
