% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirna_base_frequency.R
\name{mirnapredata}
\alias{mirnapredata}
\title{Base frequency distribution of small RNA (sRNA)}
\usage{
mirnapredata(sRNAseq)
}
\arguments{
\item{sRNAseq}{Character. All sRNA sequences in vector format.}
}
\value{
A data frame. The output consists of three columns, i.e., base, base frequency and position.
}
\description{
Get the base frequency distribution table.
}
\examples{
#F1
F1_miRNA <- F1_miRNA_count[,1]
F1_bf <- mirnapredata(sRNAseq = F1_miRNA)
#output result
head(F1_bf)
#  Base Frequency Position
#1    A        32        1
#2    C        27        1
#3    G        31        1
#4    T       115        1
#5    A        27        2
#6    C        50        2
}
