% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLF_gradients.R
\name{LLF_gradients}
\alias{LLF_gradients}
\title{The Log-likelihood Function and The Analytical Gradients in \code{EzGP} Package}
\usage{
LLF_gradients(X, Y, p, q, m, parv, tau = 0, models = 0)
}
\arguments{
\item{X}{Matrix or data frame containing the inputs of training data. Each row represents the input setting of a data point and the columns are values of quantitative variables and qualitative variables.}

\item{Y}{Vector containing the outputs of training data points.}

\item{p}{Number of quantitative factors in the given dataset \code{X}.}

\item{q}{Number of qualitative factors in the given dataset \code{X}.}

\item{m}{A vector containing numbers of levels in qualitative factors.}

\item{parv}{Parameters in the EzGP/EEzGP model.}

\item{tau}{Nugget if needed. The default nugget is 0, otherwise it has to be a non-negative real value.}

\item{models}{Model indicator that indicates which model the likelihoods and analytical gradients are applied to. 0 for EzGP model, 1 for EEzGP model.}
}
\value{
A list of the following items:
\itemize{
\item{\code{objective}} {The log-likelihood function value.}
\item{\code{gradient}} {The analytical gradients.}
}
}
\description{
Calculates the log-likelihood function value and the analytical gradients as described in \code{reference 1}.
}
\examples{
# see the examples in the documentation of the function EzGP_fit.
}
\references{
\enumerate{
\item "EzGP: Easy-to-Interpret Gaussian Process Models for Computer Experiments with Both Quantitative and Qualitative Factors", Qian Xiao, Abhyuday Mandal, C. Devon Lin, and Xinwei Deng (\doi{10.1137/19M1288462})
}
}
\seealso{
\code{\link[EzGP]{EzGP_fit}} to see how an EzGP model can be fitted to a training dataset.\cr
\code{\link[EzGP]{EzGP_predict}} to use the fitted EzGP model for prediction.\cr
\code{\link[EzGP]{EEzGP_fit}} to see how an EEzGP model can be fitted to a training dataset.\cr
\code{\link[EzGP]{EEzGP_predict}} to use the fitted EEzGP model for prediction.\cr
\code{\link[EzGP]{LEzGP_fit}} to see how a LEzGP model can be fitted to a training dataset.\cr
}
