% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{get.mpm.model}
\alias{get.mpm.model}
\title{Retrieve the Median Probability Model (MPM)}
\usage{
get.mpm.model(
  result,
  y,
  x,
  labels = F,
  family = "gaussian",
  loglik.pi = gaussian.loglik,
  params = NULL
)
}
\arguments{
\item{result}{A fitted model object (e.g., from \code{mjmcmc}, \code{gmjmcmc}, or related classes) containing the summary statistics and marginal probabilities.}

\item{y}{A numeric vector of response values. For \code{family = "binomial"}, it should contain binary (0/1) responses.}

\item{x}{A \code{data.frame} of predictor variables. Columns must correspond to features considered during model fitting.}

\item{labels}{If specified, custom labels of covariates can be used. Default is \code{FALSE}.}

\item{family}{Character string specifying the model family. Supported options are:
\itemize{
\item \code{"gaussian"} (default) - for continuous outcomes.
\item \code{"binomial"} - for binary outcomes.
\item \code{"custom"} - for user-defined likelihood functions.
}
If an unsupported family is provided, a warning is issued and the Gaussian likelihood is used by default.}

\item{loglik.pi}{A function that computes the log-likelihood. Defaults to \code{gaussian.loglik} unless \code{family = "binomial"}, in which case \code{logistic.loglik} is used. for custom family the user must specify the same likelihood that was used in the inference.}

\item{params}{Parameters of \code{loglik.pi}, if not specified NULL will be used by default}
}
\value{
A \code{bgnlm_model} object containing:
\describe{
\item{\code{prob}}{The log marginal likelihood of the MPM.}
\item{\code{model}}{A logical vector indicating included features.}
\item{\code{crit}}{Criterion label set to \code{"MPM"}.}
\item{\code{coefs}}{A named numeric vector of model coefficients, including the intercept.}
}
}
\description{
This function extracts the Median Probability Model (MPM) from a fitted model object.
The MPM includes features with marginal posterior inclusion probabilities greater than 0.5.
It constructs the corresponding model matrix and computes the model fit using the specified likelihood.
}
\examples{
\dontrun{
# Simulate data
set.seed(42)
x <- data.frame(
  PlanetaryMassJpt = rnorm(100),
  RadiusJpt = rnorm(100),
  PeriodDays = rnorm(100)
)
y <- 1 + 0.5 * x$PlanetaryMassJpt - 0.3 * x$RadiusJpt + rnorm(100)

# Assume 'result' is a fitted object from gmjmcmc or mjmcmc
result <- mjmcmc(cbind(y,x))  

# Get the MPM
mpm_model <- get.mpm.model(result, y, x, family = "gaussian")

# Access coefficients
mpm_model$coefs
}

}
