% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{initialize}
\alias{initialize}
\title{Initialize Fleming-Viot dependent Dirichlet Processes by setting hyperparameters}
\usage{
initialize(theta, sampling.f, density.f, atomic)
}
\arguments{
\item{theta}{The intensity of the centering measure, in the sense of Bayesian
Nonparametrics.}

\item{sampling.f}{A function to sample from the centering. Its unique argument
must be the amount of values to be drawn.}

\item{density.f}{A function to compute the value of the density function or
mass function of the centering. It has to be consistent with \code{sampling.f}.}

\item{atomic}{A boolean value stating whether the centering is atomic or not.}
}
\value{
A list containing the input (renamed as \code{theta}, \code{P0.sample},
\code{P0.density}, and \code{is.atomic}) and three empty slots that will contain the
information once the FVDDP is updated with data. In particular, they are:
\itemize{
\item \code{y.star}: a vector of unique values
\item \code{M}: a matrix of multiplicities, represented as row vectors
\item \code{w}: a vector of weights associated to each row of the matrix of multiplicities.
Such list repesents a n object of the \code{fvddp} class.
}
}
\description{
Initialize Fleming-Viot dependent Dirichlet Processes by setting hyperparameters
}
\examples{
#initiization with an atomic measure (Pois(3))
initialize(theta = 1, sampling.f = function(x) rpois(x, 3),
           density.f = function(x) dpois(x, 3), atomic = TRUE)

#initialization with a non-atomic measure (N(-1, 3))
initialize(theta = 3, sampling.f = function(x) rnorm(x, -1, 3),
           density.f = function(x) dnorm(x, -1, 3), atomic = FALSE)

}
\references{
{
\insertRef{PapaspiliopoulosRuggiero2014}{FVDDPpkg}

\insertRef{PapaspiliopoulosRuggieroSpanò2016}{FVDDPpkg}
}
}
