% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.qselection.R
\name{plot.qselection}
\alias{plot.qselection}
\title{Visualization of \code{qselection} object}
\usage{
\method{plot}{qselection}(x = object, y = NULL, ylab = NULL, ...)
}
\arguments{
\item{x}{\code{qselection} object.}

\item{y}{NULL}

\item{ylab}{NULL}

\item{\ldots}{Other options.}
}
\value{
Simply returns a plot.
}
\description{
This function plots the cross-validation information criterion for several
subsets of size \eqn{q} chosen by the user.
}
\examples{
library(FWDselect)
data(diabetes)
x = diabetes[ ,2:11]
y = diabetes[ ,1]
obj2 = qselection(x, y, qvector = c(1:9), method = "lm", criterion = "variance", cluster = FALSE)
plot(obj2)
}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\seealso{
\code{\link{selection}}.
}

