% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.GaussKronrod.R
\name{data.GaussKronrod}
\alias{data.GaussKronrod}
\title{Initialisation of Survival Data at Gauss Kronrod time points}
\usage{
data.GaussKronrod(data.id, Time, k = 15)
}
\arguments{
\item{data.id}{A database with covariates of interest and 1 line per subject}

\item{Time}{A vector of time event}

\item{k}{The number of Gauss Kronrod points, by default k = 15}
}
\value{
A list with the following components :
\describe{
\item{\code{K}}{an integer, the number of points}
\item{\code{P}}{a vector, of value Time/2}
\item{\code{st}}{a matrix with nrow = number of subjects and ncol = k. The new time to compute the survival function}
\item{\code{wk}}{a vector of weights}
\item{\code{data.id2}}{a database with K lines per subjects}
\item{\code{id.GK}}{the vector of IDs}
}
}
\description{
Initialisation of Survival Data at Gauss Kronrod time points
}
