% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{goodness_of_fit}
\alias{goodness_of_fit}
\title{Predictions for the goodness of fit, of the random effects, the current value for each individuals and the cumulative hazard function for both events}
\usage{
goodness_of_fit(object, graph = FALSE, break.times = NULL)
}
\arguments{
\item{object}{an object of class lsjm}

\item{graph}{a boolean to indicate to print graphics, False by default}

\item{break.times}{a vector of times for the time points of longitudinal graphic}
}
\value{
A list which contains the following elements :
\describe{
\item{\code{tables}}{A list with the table of the predicted random effect, the table of the predicted current value, table(s) of predictive cumulative hazard function(s)}
\item{\code{graphs}}{A list with 2 or 3 graphs : one for the longitudinal adjustment and one for each risk function}

}
}
\description{
Predictions for the goodness of fit, of the random effects, the current value for each individuals and the cumulative hazard function for both events
}
\examples{

\donttest{


#Fit a joint model with competing risks and subject-specific variability
example <- lsjm(formFixed = y~visit,
formRandom = ~ visit,
formGroup = ~ID,
formSurv = Surv(time, event ==1 ) ~ 1,
timeVar = "visit",
data.long = Data_toy,
variability_hetero = TRUE,
formFixedVar =~visit,
formRandomVar =~visit,
correlated_re = TRUE,
sharedtype = c("current value", "variability"),
hazard_baseline = "Weibull",
formSlopeFixed =~1,
formSlopeRandom = ~1,
indices_beta_slope = c(2), 
competing_risk = TRUE,
formSurv_CR = Surv(time, event ==2 ) ~ 1,
hazard_baseline_CR = "Weibull",
sharedtype_CR = c("current value", "variability"),
S1 = 100,
S2 = 1000,
nproc = 1,
maxiter = 100,
Comp.Rcpp = TRUE
)

#Assesment of the goodness of fit:
gof <- goodness_of_fit(example, graph = TRUE)
gof$tables
gof$graphs
}

}
