% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_diversity.R
\docType{data}
\name{FuncDiv_alpha_metrics}
\alias{FuncDiv_alpha_metrics}
\title{List object containing the functions to compute the default alpha diversity metrics}
\format{
An object of class \code{list} of length 15.
}
\usage{
FuncDiv_alpha_metrics
}
\value{
numeric vector with alpha diversity value.
}
\description{
These functions are used by the \code{alpha_div_contrib} function to compute contributional diversity,
but can be used for any arbitrary input vector as well to compute standard alpha diversity.
}
\details{
The metrics were primarily taken from definitions provided by \code{scikit-bio} Python package, as well as the \code{vegan} and \code{picante} R packages.
The functions are provided as elements of this list, so that it is more convenient to call them programatically.
All available alpha diversity metrics can be seen by typing \code{names(FuncDiv_alpha_metrics)}.
The code to compute each metric can be inspected for each function, for instance, for richness, by typing: \code{FuncDiv_alpha_metrics$richness}.

These functions all have a single input: a numeric vector containing taxa abundances within a given sample.
The exception is for \code{faiths_pd}, which expects a character vector of taxa labels that are present, as well as a tree (phylo object),
which must contain all these specified taxa labels as tip labels.

Note that not all these metrics are appropriate for relative abundance data. In particular, these metrics expect count data (e.g., read counts)
corresponding to the number of occurrences of each category (e.g., each microbe): \code{menhinicks_richness}, \code{mcintoshs_evenness}, \code{mcintoshs_dominance},
\code{margalefs_richness}, and \code{fishers_alpha}.
}
\examples{
# Most metrics just require an input vector of abundances.
test_abun <- c(0, NA, 1, 2, 10, 4)
FuncDiv_alpha_metrics[["richness"]](test_abun)

# Note that the input for computing Faith's PD is different.
# Get a randomly generated tree:
test_tree <- ape::rtree(n = 50)
test_present_tips <- c('t1', 't2', 't3')
FuncDiv_alpha_metrics[["faiths_pd"]](test_present_tips, test_tree)

}
\keyword{datasets}
