% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GADAG_Analyze.R
\name{GADAG_Analyze}
\alias{GADAG_Analyze}
\title{Analyze GADAG results.}
\usage{
GADAG_Analyze(Results, G = NULL, X = NULL, threshold = 0.1,
  plot.control = list(plot.graph = FALSE, plot.evol = FALSE, plot.png =
  FALSE))
}
\arguments{
\item{Results}{Outputs from \code{GADAG_Run()} function.}

\item{G}{(optional) Adjacency matrix corresponding to the true DAG (pxp matrix).}

\item{X}{(optional) Design matrix with samples (n) in rows and variables (p) in columns.}

\item{threshold}{Thresholding value for the edges.}

\item{plot.control}{A list containing parameters to control the produced graph outputs (\code{return.level} has to be turned to 1 in the main code beforehand):
\itemize{
\item \code{plot.graph} If TRUE, generates the figures with the actual and estimated graphs,
\item \code{plot.evol} If TRUE, generates the figures showing the evolution of the genetic algorithm (fitness value, Shannon entropy and best node ordering),
\item \code{plot.png} If TRUE, saves the figures in .png.
}}
}
\value{
A vector containing the scores of precision, recall, number of false positives (FP), false negatives (FN), true positives (TP), true negatives (TN) and mean squared error (only if \code{G} and \code{X} are provided).
}
\description{
Function to Analyze GADAG results.
}
\details{
This function returns as primary outputs the performances of the estimation graph procedure
in terms of TP, FP, FN, TN, precision and recall, obtained by comparing the estimated
graph with the true one (if known and provided).
If specified (\code{plot.graph}, \code{plot.evol}), the user can plot both the estimated graph
and the true DAG (if known and provided) and the evolution of the algorithm. This generates three figures:
the first one represents the evolution of the fitness value (best fitness in red, averaged population fitness and quantiles across the iterations),
the second onen, the evolution of the Shannon entropy of each node across the iterations, the third one, the best node ordering (permutation that minimizes the fitness) across the iterations.
}
\examples{
 #############################################################
 # Loading toy data
 #############################################################
 data(toy_data)
 # toy_data is a list of two matrices corresponding to a "star"
 # DAG (node 1 activates all other nodes):
 # - toy_data$X is a 100x10 design matrix
 # - toy_data$G is the 10x10 adjacency matrix (ground trough)

 ########################################################
 # Evaluating GADAG Results
 ########################################################
 # simple run, where you only get the precision, recall, number
 # of false positives, true positives, false negatives, true negatives
 # and mean squared error of the estimated graph

 # run GADAG with the predefined parameters
 GADAG_results <- GADAG_Run(X=toy_data$X, lambda=0.1)

 # analyze the results
 GADAG_analysis <- GADAG_Analyze(GADAG_results, G=toy_data$G, X=toy_data$X)
 print(GADAG_analysis) # here are the results

 # more complex run, where you want to have some details about the procedure
 \dontrun{
 # run GADAG with return.level set to 1 beforehand
 GADAG_results <- GADAG_Run(X=toy_data$X, lambda=0.1,return.level=1)

 # print the evolution of the algorithm
 plot.evol <- TRUE
 GADAG_analysis <- GADAG_Analyze(GADAG_results, G=toy_data$G, X=toy_data$X,
          plot.control = list(plot.evol=TRUE))

 # in addition, print the estimated and the true graph
 plot.graph <- TRUE
 GADAG_analysis <- GADAG_Analyze(GADAG_results, G=toy_data$G, X=toy_data$X,
          plot.control = list(plot.evol=plot.evol, plot.graph= plot.graph))

 # now save the results in .png, but only for the graphs
 plot.png <- TRUE
 GADAG_analysis <- GADAG_Analyze(GADAG_results, G=toy_data$G, X=toy_data$X,
          plot.control = list(plot.graph= plot.graph, plot.png = plot.png))

 # in case you don't know the true DAG, you can't really know how good the
 # estimation is. You can't compute the precision, recall, MSE but you can
 # still plot the estimated graph and see the evolution of the algorithm
 plot.graph <- plot.evol <- TRUE
 plot.png <- FALSE
 GADAG_analysis <- GADAG_Analyze(GADAG_results, X=toy_data$X,
          plot.control = list(plot.graph= plot.graph, plot.evol = plot.evol))
 }
}
\author{
\packageAuthor{GADAG}
}
