% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdeco.R
\name{gdeco}
\alias{gdeco}
\alias{print.gdeco}
\alias{plot.gdeco}
\title{Geographical detectors: ecological detector.}
\usage{
gdeco(formula, data = NULL)
\method{print}{gdeco}(x, ...)
\method{plot}{gdeco}(x, ...)
}
\arguments{
\item{formula}{A formula of response and explanatory variables}

\item{data}{A data.frame includes response and explanatory variables}

\item{x}{A list of ecological detector results}

\item{...}{Ignore}
}
\description{
Function for ecological detector calculation, ecological
matrix and visulization.
}
\examples{
ge1 <- gdeco(NDVIchange ~ Climatezone + Mining, data = ndvi_40)
ge1
\donttest{
data <- ndvi_40[,1:3]
ge2 <- gdeco(NDVIchange ~ ., data = data)
ge2
}

}
