% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdinteract.R
\name{gdinteract}
\alias{gdinteract}
\alias{print.gdinteract}
\alias{plot.gdinteract}
\title{Geographical detectors: interaction detector.}
\usage{
gdinteract(formula, data = NULL)
\method{print}{gdinteract}(x, ...)
\method{plot}{gdinteract}(x, ...)
}
\arguments{
\item{formula}{A formula of response and explanatory variables}

\item{data}{A data.frame includes response and explanatory variables}

\item{x}{A list of interaction detector results}

\item{...}{Ignore}
}
\description{
Function for interaction detector calculation and visualization.
The types of interactions include "Enhance, nonlinear", "Independent", "Enhance, bi-",
"Weaken, uni-" and "Weaken, nonlinear".
}
\examples{
gi1 <- gdinteract(NDVIchange ~ Climatezone + Mining, data = ndvi_40)
gi1
\donttest{
data <- ndvi_40[,1:3]
gi2 <- gdinteract(NDVIchange ~ ., data = data)
gi2
}

}
