% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stattable.R
\name{stattable}
\alias{stattable}
\title{Produce a two-way summary table of results}
\usage{
stattable(rowfactor, columnfactor, outcome, FUN = mean, ...)
}
\arguments{
\item{rowfactor}{variable to be included in the rows}

\item{columnfactor}{variable to be included in the columns}

\item{outcome}{vector containing outcome values}

\item{FUN}{name of summary function to use}

\item{...}{other arguments for \code{FUN}}
}
\description{
Transforms raw data into a simple two-way table for use in
\code{\link[GGEBiplots]{GGEModel}} with row names and column names. By design
rather than just a side-effect of combining \code{list} with \code{tapply}
}
\examples{
simdata<-data.frame(expand.grid(Genotype=1:10,Environment=1:10,Rep=1:3),Outcome=rnorm(300))
meantab<-stattable(simdata$Genotype,simdata$Environment,simdata$Outcome,FUN=mean,na.rm=TRUE)
GGEPlot(GGEModel(meantab))
}
\keyword{2way}
\keyword{GGEBiplotGUI}
\keyword{means}
\keyword{statistics}
\keyword{summary}
\keyword{table}
