% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMS.Lasso.R
\name{GMS.Lasso}
\alias{GMS.Lasso}
\title{Generalized Mass Spectrum missing peaks imputation with Two-Step Lasso as default algorithm}
\usage{
GMS.Lasso(input_data, alpha = 1, nfolds = 10, log.scale = TRUE,
  TS.Lasso = TRUE)
}
\arguments{
\item{input_data}{Raw abundance matrix with missing value, with features in rows and samples in columns.}

\item{alpha}{Weights for L1 penalty in Elastic Net. The default and suggested value is alpha=1, which is for Lasso.}

\item{nfolds}{The number of folds used in parameter (lambda) tuning.}

\item{log.scale}{Whether the input_data needs log scale transform.The default is log.scale=T, assuming input_data is the 
raw abundance matrix. If input_data is log abundance matrix, log.scale=F.}

\item{TS.Lasso}{Whether to use TS.Lasso or the minimum per compound for imputation.}
}
\value{
\item{imputed.final}{The imputed abundance matrix at the scale of input_data.}
}
\description{
GMS.Lasso recovers the abundance of missing peaks via either TS.Lasso or the minimum abundance per compound.
}
\examples{
data('tcga.bc')
# tcga.bc contains mass specturm abundance of 150 metabolites for 30 breast cancer 
# tumor and normal tissue samples with missing values.

imputed.compound.min=GMS.Lasso(tcga.bc,log.scale=TRUE,TS.Lasso=FALSE)
# Impute raw abundance matrix tcga.bc with compound minimum

imputed.tslasso=GMS.Lasso(tcga.bc,log.scale=TRUE,TS.Lasso=TRUE)
# Impute raw abundance matrix tcga.bc with TS.Lasso

}
