% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateCAT_species.R
\name{evaluateCAT_species}
\alias{evaluateCAT_species}
\title{Comprehensive comparison between species using categories and Pearson's
 Chi-squared Tests}
\usage{
evaluateCAT_species(df1, df2, species1, species2, GOterm_field, test = "prop")
}
\arguments{
\item{df1}{A data frame with the results of a functional enrichment analysis
for the species 1 with an extra column "feature" with the features to be compared}

\item{df2}{A data frame with the results of a functional enrichment analysis
for the species 2 with an extra column "feature" with
the features to be compared}

\item{species1}{This is a string with the species name for the species 1 (e.g; "H. sapiens")}

\item{species2}{This is a string with the species name for the species 2 (e.g; "A. thaliana")}

\item{GOterm_field}{This is a string with the column name of the GO terms
(e.g; "Functional_Category")}

\item{test}{This is a string with the hypothesis test to be performed. Two options are provided,
"prop" and "chi-squared" (default value="prop")}
}
\value{
This function will return a data.frame with the following fields:
\tabular{lcc}{
CAT \tab Category  \cr
pvalue \tab p-value obtained through the use of Pearson's Chi-squared Test\cr
FDR \tab Multiple comparison correction for the p-value column \cr
}
}
\description{
evaluateGO_species provides a simple function  to compare results
 of functional enrichment analysis for two species through the use of proportion tests or Pearson's
 Chi-squared Tests and a False discovery rate correction
}
\examples{

#Loading example datasets
data(H_sapiens)
data(A_thaliana)
#Defining the column with the GO terms to be compared
GOterm_field <- "Functional_Category"
#Defining the species names
species1 <- "H. sapiens"
species2 <- "A. thaliana"
#Running function
x <- evaluateCAT_species(df1= H_sapiens,
                       df2=A_thaliana,
                       species1=species1,
                       species2=species2,
                       GOterm_field=GOterm_field,
                         test="prop")
print(x)
}
