% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateWrappedGP.R
\name{CreateWrappedGP}
\alias{CreateWrappedGP}
\title{Factory function called by GPNode to create the wrapper for a specified GP package}
\usage{
CreateWrappedGP(
  wrapper,
  X,
  y,
  y_var,
  gp_control,
  init_covpars,
  retrain_buffer_length,
  add_buffer_in_prediction
)
}
\arguments{
\item{wrapper}{A string specifying what GP implementation is used}

\item{X}{Input data matrix with x_dim columns and at maximum Nbar rows. Is used to create the first iteration of the local GP.}

\item{y}{Value of target variable at input point x; has to be a one-dimensional matrix or a vector; any further columns will be ignored}

\item{y_var}{Variance of the target variable; has to be a one-dimensional matrix or vector}

\item{gp_control}{A list of GP implementation-specific options, passed directly to the wrapped GP implementation}

\item{init_covpars}{Initial covariance parameters of the local GP}

\item{retrain_buffer_length}{Only retrain when the number of buffer points or collected points exceeds this value}

\item{add_buffer_in_prediction}{If TRUE, points in the data buffers are added to the GP before prediction. They are added into a temporarily created GP which contains the not yet included points. The GP in the node is not yet updated.}
}
\value{
The wrapper of the chosen GP package, containing the respective GP and information on the shared points and those stored in the buffer.
}
\description{
Factory function called by GPNode to create the wrapper for a specified GP package
}
\details{
A detailed list of expected functions from GPTree and GPNode can be found in the comments of this file. Currently, GPs from the \code{DiceKriging} package (\link{WrappedDiceKrigingGP}) and \code{mlegp} package (\link{WrappedmlegpGP}) are implemented. The user can create their own wrapper using \link{WrappedGP}.
}
