% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_arguments.R
\name{check_arg_mapper}
\alias{check_arg_mapper}
\title{check_arg_mapper}
\usage{
check_arg_mapper(
  full_data,
  filter_values,
  distance_type,
  clustering_type,
  linkage_type,
  optimal_clustering_mode = NA,
  silhouette_threshold = 0.25,
  na.rm = TRUE
)
}
\arguments{
\item{full_data}{Matrix with the columns of the input matrix
corresponding to the individuals belonging to the level.}

\item{filter_values}{Vector obtained after applying the filtering function
to the input matrix, i.e, a vector with the filtering function
values for each included sample.}

\item{distance_type}{Type of distance to be used for clustering.
Choose between correlation ("correlation") and euclidean ("euclidean"). "correlation"
default option.}

\item{clustering_type}{Type of clustering method. Choose between
"hierarchical" and "PAM" (“partition around medoids”) options.
"hierarchical" default option.}

\item{linkage_type}{Linkage criteria used in hierarchical clustering.
Choose between "single" for single-linkage clustering, "complete" for
complete-linkage clustering or "average" for average linkage clustering
(or UPGMA). Only necessary for hierarchical clustering.
"single" default option.}

\item{optimal_clustering_mode}{Method for selection optimal number of
clusters. It is only necessary if the chosen type of algorithm is
hierarchical. In this case, choose between "standard" (the method used
in the original mapper article) or "silhouette". In the case of the PAM
algorithm, the method will always be "silhouette".}

\item{silhouette_threshold}{Minimum value of \eqn{\overline{s}}{s-bar} that a set of
clusters must have to be chosen as optimal. Within each interval of the
filter function, the average silhouette values \eqn{\overline{s}}{s-bar} are computed
for all possible partitions from $2$ to $n-1$, where $n$ is the number of
samples within a specific interval. The $n$ that produces the highest value
of \eqn{\overline{s}}{s-bar} and that exceeds a specific threshold is selected as the
optimum number of clusters. If no partition produces an \eqn{\overline{s}}{s-bar}
exceeding the chosen threshold, all samples are then assigned to a unique
cluster. The default value is $0.25$. The threshold of $0.25$ for
\eqn{\overline{s}}{s-bar} has been chosen based on standard practice, recognizing it
as a moderate value that reflects adequate separation and cohesion within
clusters.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.
If \code{FALSE}, an error occurs in case of \code{NA} rows.}
}
\value{
\code{optimal_clustering_mode}
}
\description{
Checking the arguments introduces in the \code{mapper} object.
}
