% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/One_D_Mapper.R
\name{clust_lev}
\alias{clust_lev}
\title{Get clusters for a particular data level}
\usage{
clust_lev(
  data_i,
  distance_type,
  clustering_type,
  linkage_type,
  optimal_clustering_mode,
  silhouette_threshold = 0.25,
  num_bins_when_clustering,
  level_name
)
}
\arguments{
\item{data_i}{Matrix with the columns of the input matrix
corresponding to the individuals belonging to the level.}

\item{distance_type}{Type of distance to be used for clustering.
Choose between correlation ("correlation") and euclidean ("euclidean").}

\item{clustering_type}{Type of clustering method.
Choose between "hierarchical" and "PAM" (“partition around medoids”)
options.}

\item{linkage_type}{Linkage criteria used in hierarchical clustering.
Choose between "single" for single-linkage clustering, "complete" for
complete-linkage clustering or "average" for average linkage clustering
(or UPGMA). Only necessary for hierarchical clustering. The value provided
if the type of clustering chosen is hierarchical will be ignored}

\item{optimal_clustering_mode}{Method for selection optimal number of
clusters. It is only necessary if the chosen type of algorithm is
hierarchical. In this case, choose between "standard" (the method used
in the original mapper article) or "silhouette". In the case of the PAM
algorithm, the method will always be "silhouette".}

\item{silhouette_threshold}{Minimum value of \eqn{\overline{s}}{s-bar} that a set of
clusters must have to be chosen as optimal. Within each interval of the
filter function, the average silhouette values \eqn{\overline{s}}{s-bar} are computed
for all possible partitions from $2$ to $n-1$, where $n$ is the number of
samples within a specific interval. The $n$ that produces the highest value
of \eqn{\overline{s}}{s-bar} and that exceeds a specific threshold is selected as the
optimum number of clusters. If no partition produces an \eqn{\overline{s}}{s-bar}
exceeding the chosen threshold, all samples are then assigned to a unique
cluster. The default value is $0.25$. The threshold of $0.25$ for
\eqn{\overline{s}}{s-bar} has been chosen based on standard practice, recognizing it
as a moderate value that reflects adequate separation and cohesion within
clusters.}

\item{num_bins_when_clustering}{Number of bins to generate the histogram
employed by the standard optimal number of cluster finder method.
Parameter not necessary if the "optimal_clust_mode" option is "silhouette"
or the "clust_type" is "PAM".}

\item{level_name}{Name of the studied level. # ERROR No usado}
}
\value{
Returns a interger vector with the samples included in each cluster
for the specific level analyzed. The names of the vector values are the
names of the samples and the vector values are the node number
to which the individual belongs.
}
\description{
It performs clustering of the samples belonging to a particular level (to a
particular interval of the filter function) with the proposed clustering
algorithm and the proposed method to determine the optimal number
of clusters.
}
