% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz_mixed_model.R
\name{gompertz_mixed_model}
\alias{gompertz_mixed_model}
\title{Fit a Gompertz mixed-effects regression model}
\usage{
gompertz_mixed_model(
  data_frame,
  model_type = "mixed",
  fixed_rate = TRUE,
  num_chains = 1,
  seed = NULL
)
}
\arguments{
\item{data_frame}{A data frame object that at minimum contains three
variables:
\itemize{
\item cluster - a character type variable used to specify how observations
are nested or grouped by a particular cluster. Note if using a
least-squares model, please fill in all values of cluster with a single
placeholder character string, do NOT leave blank.
\item time - a numeric type variable used for measuring time such as
minutes, hours, or days
\item growth_metric - a numeric type variable used for measuring growth
over time such as cell count or confluency
}}

\item{model_type}{A character string specifying the type of regression
model to be used. If 'mixed', a mixed-effects regression model will be used
with fixed and random-effects to account for clustering. For
'least-squares', a least-squares regression model with only fixed-effects
is applied. Defaults to "mixed".}

\item{fixed_rate}{A logical value specifying whether the rate constant
of the function should be treated as a fixed effect (TRUE) or random
effect (FALSE). Defaults to TRUE}

\item{num_chains}{A numeric value specifying the number of chains to run
in parallel in the MCMC algorithm of saemix. Increasing the number of chains
may improve convergence but may also increase the computational time.
Defaults to 1.}

\item{seed}{A numeric value specifying a seed number to reproduce the
random starting values sampled within the function. Defaults to NULL.}
}
\value{
Returns a Gompertz model object of class 'SaemixObject' if a
mixed-effects model is specified or a model object of class 'nls' if a
least-squares model is specified.
}
\description{
This function is utilized within the
\code{\link{growth_curve_model_fit}} function for fitting a Gompertz
mixed-effects regression model to growth data utilizing the saemix package.
Starting values are derived from an initial least-squares model using
the \code{\link[minpack.lm]{nlsLM}} function.
}
\examples{
\donttest{
# Load example data (Gompertz data from GrowthCurveME package)
data(gomp_mixed_data)
# Fit a Gompertz mixed-effects growth model
gomp_mixed_model <- growth_curve_model_fit(
  data_frame = gomp_mixed_data,
  function_type = "gompertz"
)
# Fit a Gompertz mixed-effected model using gompertz_mixed_model()
gomp_mixed_model <- gompertz_mixed_model(data_frame = gomp_mixed_data)
}
}
\seealso{
\code{\link{growth_curve_model_fit}}
}
