% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2SPOR.R
\name{H2SPOR}
\alias{H2SPOR}
\title{Inference method for two regimes}
\usage{
H2SPOR(X, Y, deg, constraint = 1, EM = TRUE, TimeTrans_Prop = c(),
  plotG = TRUE)
}
\arguments{
\item{X}{A numerical vector corresponding to the explanatory variable. X must be sorted in ascending order
if this is not the case, X will be sorted in the function and the corresponding permutation will be applied to Y. The
user will be notified by a warning message. In addition, if X contains NAs, they will be deleted from the data and the user will be notified by a warning message.
Finally, if X contains duplicate data, the excess data will be deleted and the user will be notified by a warning message.}

\item{Y}{A numerical vector corresponding to the variable to be explain. It should contain two regimes that
could be modelled by polynomials. In addition, if Y contains NAs they will be deleted from the data and the
user will be notified by a warning message. Finally, if X contains dupplicate data, the excess data will be deleted and
the value of the remaining Y will become the average of the Ys, calculated for this value of X.}

\item{deg}{The degree of polynomials. The size of X and Y must be greater than 2(deg+2) + 1.}

\item{constraint}{Number that determines the regularity assumption that is applied for the parameters estimation.
By default, the variable is set to 1, i. e. the parameters estimation is done under continuity constraint.
If the variable is 0 or 2, the estimation of the parameters will be done without assumption of regularity
(constraint = 0) or under assumption of differentiability (constraint = 2). Warning, if the differentiability
assumption is not verified by the model, it is preferable not to use it to estimate the model parameters.
In addition, if the degree of the polynomials is equal to 1, you cannot use the differentiability assumption.}

\item{EM}{A Boolean. If EM is TRUE (default), then the function will estimate the parameters
of a latent variable polynomial regression model using an EM algorithm. If EM is FALSE then
the function will estimate the parameters of the initial polynomial regression model by a fixed point algorithm.}

\item{TimeTrans_Prop}{A numerical vector. This vector is empty by default. If you want to estimate the model
parameters for a fixed jump time value, you can propose this value here.}

\item{plotG}{A Boolean. If TRUE (default) the estimation results obtained by the H2SPOR function are plotted.}
}
\value{
A dataframe that contains the estimated parameters of the polynomial regression model at two regimes:
the jump time, the coefficients of the polynomials and the variances of the two regimes.
If plotG = TRUE, the data (X,Y) and the estimated model will be plotted.
}
\description{
H2SPOR is an inference method that estimates, under regularity constraint, the parameters of a
polynomial regression model with 2 regimes.
}
\examples{


#generated data with two regimes
set.seed(1)

xgrid1 = seq(0,10,length.out=6)
xgrid2 = seq(10.2,20,length.out=6)
ygrid1 = xgrid1^2-xgrid1+1+ rnorm(length(xgrid1),0,3)
ygrid2 = rep(91,length(xgrid2))+ rnorm(length(xgrid2),0,3)
xgrid = c(xgrid1,xgrid2)
ygrid = c(ygrid1,ygrid2)

#Inference of a polynomial regression model with two regimes on these data.
#The degree of the polynomials is fixed to 2 and the parameters are estimated
#under continuity constraint.
H2SPOR(xgrid,ygrid,2,1,EM=FALSE,c())

\donttest{
set.seed(1)
xgrid1 = seq(0,10,by=0.2)
xgrid2 = seq(10.2,20,by=0.2)
ygrid1 = xgrid1^2-xgrid1+1+ rnorm(length(xgrid1),0,3)
ygrid2 = rep(91,length(xgrid2))+ rnorm(length(xgrid2),0,3)
xgrid = c(xgrid1,xgrid2)
ygrid = c(ygrid1,ygrid2)

#Inference of a polynomial regression model with two regimes on these data.
#The degree of the polynomials is fixed to 2 and the parameters are estimated
#under continuity constraint.
H2SPOR(xgrid,ygrid,2,1,EM=FALSE,c())
#Executed time : 9.69897 secs (intel core i7 processor)
}
}
