% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembly.R
\name{hapiAssembleEnd}
\alias{hapiAssembleEnd}
\title{Assembly of haplotypes in regions at the end of a chromosome}
\usage{
hapiAssembleEnd(gmt, draftHap, consensusHap, k = 300)
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells}

\item{draftHap}{a dataframe with draft haplotype information}

\item{consensusHap}{a dataframe of the consensus haplotype information}

\item{k}{a numeric value for the number of hetSNPs that will be combined
with markers beyond the framework for assembly. Default is 300}
}
\value{
a dataframe containing phased haplotypes
}
\description{
Assembly of haplotypes in regions at the end of a chromosome
}
\examples{
finalDraft <- rep(0,500)
names(finalDraft) <- seq_len(500)

ref <- rep(0,500)
alt <- rep(1,500)

gmtDa <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

idx1 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx2 <- sort(sample(seq_len(500), 30, replace = FALSE))
idx3 <- sort(sample(seq_len(500), 30, replace = FALSE))

gmtDa[idx1,1] <- NA
gmtDa[idx2,2] <- NA
gmtDa[idx3,3] <- NA

consensusHap <- data.frame(hap1=rep(0,500),hap2=rep(1,500),
total=rep(5,500),rate=rep(1,500),
confidence=rep('F',500),
stringsAsFactors = FALSE)
rownames(consensusHap) <- seq_len(500)

consensusHap <- hapiAssembleEnd(gmt = gmtDa, draftHap = finalDraft, 
consensusHap = consensusHap, k = 300)
}
\author{
Ruidong Li
}
