% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DescriptiveStats.R
\name{GetEmpFreq}
\alias{GetEmpFreq}
\title{Empirical nonexceedance frequency}
\usage{
GetEmpFreq(i, n, formula = "Hazen")
}
\arguments{
\item{i}{integer or integer vector, observation rank(s)}

\item{n}{integer, number of observations}

\item{formula}{character, formula, available: 'Hazen', 'Standard', 'MinusOne', 'Weibull',
'Benard', 'Cunnane', 'Beard', 'Blom', 'Gringorten', 'Landwehr', 'Tukey'.}
}
\value{
The nonexceedance frequency.
}
\description{
Computes the empirical nonexceedance frequency of the ith sorted value amongst n
}
\examples{
GetEmpFreq(i=1:10,n=10)
GetEmpFreq(i=1:10,n=10,formula='Standard')
GetEmpFreq(i=1:10,n=10,formula='MinusOne')
GetEmpFreq(i=1:10,n=10,formula='Cunnane')
}
