% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrdinaryCalibration.R
\name{FitCalibCox}
\alias{FitCalibCox}
\title{Fitting Proportional Hazards Calibration Models with Covariates}
\usage{
FitCalibCox(w, w.res, Q, hz.times, n.int = 5, order = 2)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. It corresponds to the time points in \code{w}}

\item{Q}{Matrix of covariates for PH calibration model}

\item{hz.times}{Times used for calculating the baseline hazard function from PH calibration model}

\item{n.int}{The number of interior knots to be used, see \code{ICsurv::fast.PH.ICsurv.EM}, Default: 5}

\item{order}{the order of the basis functions. See \code{ICsurv::fast.PH.ICsurv.EM}, Default: 2}
}
\value{
An object created by ICsurv::fast.PH.ICsurv.EM, with additional variables \code{knots} and \code{order}.
}
\description{
Fits a proportional hazards calibration model for time-to-exposure from interval-censored data with covariates. The exposure is a binary covariate measured
in intermittent times. The covariates (\code{Q}) are associated with the time-to-exposure.
}
\examples{
sim.data <- ICcalib:::SimCoxIntervalCensCox(n.sample = 200, lambda = 0.1, 
                                            alpha = 0.25, beta0 = 0, 
                                            gamma.q = c(log(0.75), log(2.5)), 
                                            gamma.z = log(1.5), mu = 0.2, 
                                            n.points = 2)
# The baseline hazard for the calibration model is calculated in observation times
cox.hz.times <- sort(unique(sim.data$obs.tm)) 
# Fit proprtional hazards calibration model
FitCalibCox(w = sim.data$w, w.res = sim.data$w.res, Q = sim.data$Q, 
            hz.times = cox.hz.times, n.int = 5, order = 2)
}
\seealso{
\code{\link[ICsurv]{fast.PH.ICsurv.EM}}
}
