% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDS.R
\name{calcDS}
\alias{calcDS}
\title{Calculates discrimination score (DS)}
\usage{
calcDS(df)
}
\arguments{
\item{df}{A data frame with the first column noting individual identity of the sample.}
}
\value{
Proportion of samples correctly classified by LDA in \code{df}.
}
\description{
This function will take the specified data frame and will perform linear
discrimination analysis with leave-one-out crossvalidation and equal priors
for each individual (e.g., all priors will be set to 1/10 in case that the
dataset contains 10 individuals). Variables are not modified in any way;
scaling, centering, transformation of variables, or principal component
analysis, etc., if required, need to be done on dataset before calling this
function. \cr\cr \strong{Reference:} e.g. Hafner, G. W., Hamilton, C. L.,
Steiner, W. W., Thompson, T. J., & Winn, H. E. (1979). Signature information
in the song of the humpback whale. Journal of the Acoustical Society of
America, 66, 1-6. doi:10.1121/1.383072 \cr\cr
}
\examples{
calcDS(ANmodulation)

}
\seealso{
Other individual identity metrics: \code{\link{calcF}},
  \code{\link{calcHM}}, \code{\link{calcHSngroups}},
  \code{\link{calcHSnpergroup}}, \code{\link{calcHSntot}},
  \code{\link{calcHSvarcomp}}, \code{\link{calcHS}},
  \code{\link{calcMI}}, \code{\link{calcPICbetweenmeans}},
  \code{\link{calcPICbetweentot}}, \code{\link{calcPIC}}
}
\concept{individual identity metrics}
