% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMeanVec.R
\name{calcMeanVec}
\alias{calcMeanVec}
\title{Calculate the centroid of the individual identity traits}
\usage{
calcMeanVec(df)
}
\arguments{
\item{df}{A data frame with the individual identity traits without identity
codes (NA will be produced for the column with identity code).}
}
\value{
Numeric vector with the centroid values for each trait.
}
\description{
This function calculates centroid of the individual identity traits.
Euclidean distances are used.
}
\examples{
#incorrect use (with identity codes, NA will be produced):
calcMeanVec(ANmodulation)

#correct use (with identity codes removed)
calcMeanVec(ANmodulation[-1])

}
\seealso{
Other calcHM support function: \code{\link{calcDistT}},
  \code{\link{calcDistW}}
}
\concept{calcHM support function}
