% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_generic0.R
\name{cgeneric_generic0}
\alias{cgeneric_generic0}
\alias{cgeneric_iid}
\title{Build an \code{cgeneric} object for a \code{generic0} model.
See details.}
\usage{
cgeneric_generic0(R, param, constr = TRUE, scale = TRUE, ...)

cgeneric_iid(n, param, constr = FALSE, ...)
}
\arguments{
\item{R}{the structure matrix for the model definition.}

\item{param}{length two vector with the parameters
\code{a} and \code{p} for the PC-prior distribution defined from
\deqn{P(\sigma > a) = p}
where \eqn{\sigma} can be interpreted as marginal standard
deviation of the process if scale = TRUE. See details.}

\item{constr}{logical indicating if it is to add a
sum-to-zero constraint. Default is TRUE.}

\item{scale}{logical indicating if it is to scale
the model. See detais.}

\item{...}{arguments (debug,useINLAprecomp,libpath)
passed on to \code{\link[=cgeneric]{cgeneric()}}.}

\item{n}{integer required to specify the model size}
}
\value{
a \code{cgeneric} object, see \code{\link[=cgeneric]{cgeneric()}}.
}
\description{
Build data needed to implement a model whose
precision has a conditional precision parameter.
This uses the C interface in the 'INLA' package,
that can be used as a linear predictor
model component with an 'f' term.
}
\details{
The precision matrix is defined as
\deqn{Q = \tau R}
where the structure matrix R is supplied by the user
and \eqn{\tau} is the precision parameter.
Following Sørbie and Rue (2014), if scale = TRUE
the model is scaled so that
\deqn{Q = \tau s R}
where \eqn{s} is the geometric mean of the diagonal
elements of the generalized inverse of \eqn{R}.
\deqn{s = \exp{\sum_i \log((R^{-})_{ii})/n}}
If the model is scaled, the geometric mean of the
marginal variances, the diagonal of \eqn{Q^{-1}}, is one.
Therefore, when the model is scaled,
\eqn{\tau} is the marginal precision,
otherwise \eqn{\tau} is the conditional precision.
}
\section{Functions}{
\itemize{
\item \code{cgeneric_iid()}: The \link{cgeneric_iid} uses the \link{cgeneric_generic0}
with the structure matrix as the identity.

}}
\examples{
## structured precision matrix model definition
R <- Matrix(toeplitz(c(2,-1,0,0,0)))
R
mR <- cgeneric("generic0", R = R,
  param = c(1, 0.05), scale = FALSE)
graph(mR)
prec(mR, theta = 0)
}
\references{
Sigrunn Holbek Sørbye and Håvard Rue (2014).
Scaling intrinsic Gaussian Markov random field priors in
spatial modelling. Spatial Statistics, vol. 8, p. 39-51.
}
\seealso{
\code{\link[=prior.cgeneric]{prior.cgeneric()}}
}
