% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableIncidence}
\alias{tableIncidence}
\title{Table of incidence results}
\usage{
tableIncidence(
  result,
  type = "gt",
  header = c("estimate_name"),
  groupColumn = c("cdm_name", "outcome_cohort_name"),
  settingsColumn = c("denominator_age_group", "denominator_sex"),
  hide = c("denominator_cohort_name", "analysis_interval"),
  style = "default",
  .options = list()
)
}
\arguments{
\item{result}{Incidence results}

\item{type}{Type of table. Can be "gt", "flextable", or "tibble"}

\item{header}{A vector specifying the elements to include in the header. The
order of elements matters, with the first being the topmost header.
The header vector can contain one of the following variables: "cdm_name",
"denominator_cohort_name", "outcome_cohort_name", "incidence_start_date",
"incidence_end_date", "estimate_name", variables in the \code{strata_name} column,
and any of the settings columns specified in \code{settingsColumn} argument.
The header can also include other names to use as overall header labels}

\item{groupColumn}{Variables to use as group labels. Allowed columns are the
same as in \code{header}}

\item{settingsColumn}{Variables from the settings attribute to display in
the table}

\item{hide}{Table columns to exclude, options are the ones described in
\code{header}}

\item{style}{A style supported by visOmopResults::visOmopTable()}

\item{.options}{Table options to apply}
}
\value{
Table of results
}
\description{
Table of incidence results
}
\examples{
\donttest{
cdm <- mockIncidencePrevalence(sampleSize = 1000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator",
  cohortDateRange = c(as.Date("2008-01-01"), as.Date("2018-01-01"))
)
inc <- estimateIncidence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
tableIncidence(inc)
}
}
