% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{startup_funding_tbl_df}
\alias{startup_funding_tbl_df}
\title{Indian Startup Funding}
\format{
A tibble with 3,044 observations and 10 variables:
\describe{
  \item{Sr No}{Serial number of the record (numeric)}
  \item{Date dd/mm/yyyy}{Date of the funding record in dd/mm/yyyy format (character)}
  \item{Startup Name}{Name of the startup (character)}
  \item{Industry Vertical}{Primary industry vertical of the startup (character)}
  \item{SubVertical}{Specific sub-vertical within the industry (character)}
  \item{City  Location}{City where the startup is located (character)}
  \item{Investors Name}{Name(s) of the investor(s) (character)}
  \item{InvestmentnType}{Type of investment (character)}
  \item{Amount in USD}{Funding amount in US dollars (character)}
  \item{Remarks}{Additional remarks related to the record (character)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/sudalairajkumar/indian-startup-funding}
}
\usage{
data(startup_funding_tbl_df)
}
\description{
This dataset, startup_funding_tbl_df, is a tibble containing detailed funding
information for startups in India. It includes the serial number, date, startup name,
industry vertical, sub-vertical, city location, investors' names, investment type,
amount in USD, and any additional remarks. The dataset preserves the original
structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'startup_funding_tbl_df' to maintain consistency
with the naming conventions in the IndiAPIs package. The suffix 'tbl_df' indicates
that this is a tibble data frame. The original content has not been modified in any way.
}
