% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{hpd}
\alias{hpd}
\title{Calculate highest posterior density}
\usage{
hpd(calib, prob = 0.95, return.raw = FALSE, rounded = 1)
}
\arguments{
\item{calib}{The calibrated distribution, as returned from caldist()}

\item{prob}{Probability range which should be calculated. Default \code{prob=0.95}.}

\item{return.raw}{The raw data to calculate hpds can be returned, e.g. to draw polygons of the calibrated distributions. Defaults to \code{return.raw=FALSE}.}

\item{rounded}{Rounding for reported probabilities. Defaults to 1 decimal.}
}
\description{
Calculate highest posterior density ranges of calibrated distribution
}
\examples{
hpd(caldist(130,20))
plot(tmp <- caldist(2450,50), type='l')
abline(v=hpd(tmp)[,1:2], col=4)
}
