% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPC.R
\name{KPCRKHS}
\alias{KPCRKHS}
\title{Kernel partial correlation with RKHS method}
\usage{
KPCRKHS(
  Y,
  X = NULL,
  Z,
  ky = kernlab::rbfdot(1/(2 * stats::median(stats::dist(Y))^2)),
  kx = kernlab::rbfdot(1/(2 * stats::median(stats::dist(X))^2)),
  kxz = kernlab::rbfdot(1/(2 * stats::median(stats::dist(cbind(X, Z)))^2)),
  eps = 0.001,
  appro = FALSE,
  tol = 1e-05
)
}
\arguments{
\item{Y}{a matrix (n by dy)}

\item{X}{a matrix (n by dx) or \code{NULL} if \eqn{X} is empty}

\item{Z}{a matrix (n by dz)}

\item{ky}{a function \eqn{k(y, y')} of class \code{kernel}. It can be the kernel implemented in \code{kernlab} e.g., Gaussian kernel: \code{rbfdot(sigma = 1)}, linear kernel: \code{vanilladot()}.}

\item{kx}{the kernel function for \eqn{X}}

\item{kxz}{the kernel function for \eqn{(X, Z)} or for \eqn{Z} if \eqn{X} is empty}

\item{eps}{a small positive regularization parameter for inverting the empirical cross-covariance operator}

\item{appro}{whether to use incomplete Cholesky decomposition for approximation}

\item{tol}{tolerance used for incomplete Cholesky decomposition (implemented by the function \code{inchol} in the package \code{kernlab})}
}
\value{
The algorithm returns a real number which is the estimated KPC.
}
\description{
Compute estimate of Kernel partial correlation (KPC) coefficient using conditional mean embeddings in the reproducing kernel Hilbert spaces (RKHS).
}
\details{
The kernel partial correlation (KPC) coefficient measures the conditional dependence
between \eqn{Y} and \eqn{Z} given \eqn{X}, based on an i.i.d. sample of \eqn{(Y, Z, X)}.
It converges to the population quantity (depending on the kernel) which is between 0 and 1.
A small value indicates low conditional dependence between \eqn{Y} and \eqn{Z} given \eqn{X}, and
a large value indicates stronger conditional dependence.
If \code{X = NULL}, it measures the unconditional dependence between \eqn{Y} and \eqn{Z}.
}
\examples{
n = 500
set.seed(1)
x = rnorm(n)
z = rnorm(n)
y = x + z + rnorm(n,1,1)
library(kernlab)
k = vanilladot()
KPCRKHS(y, x, z, k, k, k, 1e-3/n^(0.4), appro = FALSE)
# 0.4854383 (Population quantity = 0.5)
KPCRKHS(y, x, z, k, k, k, 1e-3/n^(0.4), appro = TRUE, tol = 1e-5)
# 0.4854383 (Population quantity = 0.5)
}
\seealso{
\code{\link{KPCgraph}}
}
