% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSEA.Complete.R
\name{KSEA.Complete}
\alias{KSEA.Complete}
\title{The Complete KSEA App Analysis}
\usage{
KSEA.Complete(KSData, PX, NetworKIN, NetworKIN.cutoff, m.cutoff, p.cutoff)
}
\arguments{
\item{KSData}{the Kinase-Substrate dataset uploaded from the file 
prefaced with "PSP&NetworKIN_"
available from github.com/casecpb/KSEA/}

\item{PX}{the experimental data file formatted exactly as described below;
must have 6 columns in the exact order: Protein, Gene, Peptide, Residue.Both, p, FC;
cannot have NA values, or else the entire peptide row is deleted;
Description of each column in PX: 
\itemize{
    \item{"Protein"}{ the Uniprot ID for the parent protein} 
    \item{"Gene"}{ the HUGO gene name for the parent protein} 
    \item{"Peptide"}{ the peptide sequence}
    \item{"Residue.Both"}{ all phosphosites from that peptide, separated by semicolons if applicable;
                     must be formatted as the single amino acid abbrev. with the residue position (e.g. S102)}
    \item{"p"}{ the p-value of that peptide (if none calculated, please write "NULL", cannot be NA)}
    \item{"FC"}{ the fold change (not log-transformed); usually the control sample is the denominator}
    }}

\item{NetworKIN}{a binary input of TRUE or FALSE, indicating whether or not to include NetworKIN predictions; 
NetworKIN = TRUE means inclusion of NetworKIN predictions}

\item{NetworKIN.cutoff}{a numeric value between 1 and infinity setting the minimum NetworKIN score 
(can be left out if NetworKIN = FALSE)}

\item{m.cutoff}{a numeric value between 0 and infinity indicating the min. # of substrates 
a kinase must have to be included in the bar plot output}

\item{p.cutoff}{a numeric value between 0 and 1 indicating the p-value cutoff for
indicating significant kinases in the bar plot}
}
\value{
creates the following outputs that are deposited into your working directory: 
        a bar plot highlighting key kinase results, a .csv file of all KSEA kinase scores, 
        and a .csv file listing all kinase-substrate relationships used for the calculations
}
\description{
Takes a formatted phoshoproteomics data input and performs KSEA calculations to infer relative kinase activities
}
\examples{
KSEA.Complete(KSData, PX, NetworKIN=TRUE, NetworKIN.cutoff=5, m.cutoff=5, p.cutoff=0.01)
KSEA.Complete(KSData, PX, NetworKIN=FALSE, m.cutoff=2, p.cutoff=0.05)

}
\references{
Casado et al. (2013) Sci Signal. 6(268):rs6

Hornbeck et al. (2015) Nucleic Acids Res. 43:D512-20

Horn et al. (2014) Nature Methods 11(6):603-4
}
