% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.mtd.kb.R
\name{select.mtd.kb}
\alias{select.mtd.kb}
\title{Maximum Tolerated Dose (MTD) Selection for Single-agent Trials}
\usage{
select.mtd.kb(
  target,
  npts,
  ntox,
  cutoff.eli = 0.95,
  extrasafe = FALSE,
  offset = 0.05
)
}
\arguments{
\item{target}{The target dose-limiting toxicity (DLT) rate.}

\item{npts}{A vector containing the number of patients treated at each dose level.}

\item{ntox}{A vector containing the number of patients at each dose level who experienced a DLT at each dose level.}

\item{cutoff.eli}{The cutoff to eliminate an overly toxic dose and all
higher doses for safety.\cr
The default value is 0.95.}

\item{extrasafe}{Set \code{extrasafe=TRUE} to impose a stricter
stopping rule.\cr
The default is FALSE.}

\item{offset}{A small positive number (between 0 and 0.5) to control how
 strict the stopping rule is when \code{extrasafe=TRUE}. A
 larger value leads to a stricter stopping rule.\cr
The default value is 0.05.}
}
\value{
The function returns a list with: \cr
\enumerate{
  \item the target toxicity probability (\code{$target}),\cr
  \item the selected MTD (\code{$MTD}),\cr
  \item the isotonic estimates of the DLT probability at each dose and corresponding \code{95\%} credible interval (\code{$p_est}),\cr
  \item the probability of overdosing defined as\cr
      \eqn{Pr(toxicity > target | data)} (\code{$p_overdose}).
}
}
\description{
This function selects the maximum tolerated dose (MTD) after the single-agent trial is
completed.
}
\details{
The Keyboard design starts by specifying a target toxicity interval
(referred to as the "target key") such that any dose with a toxicity
probability within that interval can be practically viewed as the MTD.
Based on this interval's width, the Keyboard design forms a series of
equally wide keys that span the rest of range from 0 to 1.

This function selects the MTD based on isotonic estimates of toxicity
probabilities, selecting dose level \eqn{j*} for which the isotonic estimate
of the DLT rate is closest to the target. If there are ties, then we select from
the ties the highest dose level when the estimate of the DLT rate is smaller
than the target, or the lowest dose level when the estimate of the DLT rate
is greater than the target. The isotonic estimates are obtained by applying the
pooled-adjacent-violators algorithm (PAVA) [Barlow, 1972].


For some applications, investigators may prefer a stricter stopping rule
to ensure the lowest dose is not overly toxic. This can be achieved
by setting \code{extrasafe=TRUE}, which imposes the following stricter
safety stopping rule:\cr
Stop the trial if \cr
(i) the number of patients treated at the lowest dose \eqn{\ge 3}, and \cr
(ii) \deqn{Pr((toxicity rate of the lowest dose > target) | data)
           > cutoff.eli - offset}
As a tradeoff, the strong stopping rule will decrease the MTD selection
percentage when the lowest dose actually is the MTD.
}
\note{
The MTD selection and dose escalation/de-escalation rules are two
  independent components of the trial design. When appropriate, another dose
  selection procedure (e.g., one based on a fitted logistic model) can be used
  to select the MTD after completing the trial using the Keyboard design.
}
\examples{
### Single-agent trial ###

n <- c(3, 3, 15, 9, 0)
y <- c(0, 0, 4, 4, 0)

selmtd <- select.mtd.kb(target=0.3, npts=n, ntox=y)

selmtd

}
\references{
Yan F, Mandrekar SJ, Yuan Y. Keyboard: A Novel Bayesian Toxicity Probability
Interval Design for Phase I Clinical Trials.
\emph{Clinical Cancer Research}. 2017; 23:3994-4003.
http://clincancerres.aacrjournals.org/content/23/15/3994.full-text.pdf
}
\seealso{
Other single-agent functions: 
\code{\link{get.boundary.kb}()},
\code{\link{get.oc.kb}()}
}
\author{
Xiaomeng Yuan, Chen Li, Hongying Sun, Li Tang and Haitao Pan
}
\concept{single-agent functions}
