% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L2E_sparse_ncv.R
\name{L2E_sparse_ncv}
\alias{L2E_sparse_ncv}
\title{Solution path of L2E sparse regression with existing penalization methods}
\usage{
L2E_sparse_ncv(
  y,
  X,
  b,
  tau,
  lambdaSeq,
  penalty = "MCP",
  max_iter = 100,
  tol = 1e-04,
  Show.Time = TRUE
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix}

\item{b}{Initial vector of regression coefficients, can be omitted}

\item{tau}{Initial precision estimate, can be omitted}

\item{lambdaSeq}{A decreasing sequence of values for the tuning parameter lambda, can be omitted}

\item{penalty}{Available penalties include lasso, MCP and SCAD.}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}

\item{Show.Time}{Report the computing time}
}
\value{
Returns a list object containing the estimates for beta (matrix) and
tau (vector) for each value of the tuning parameter lambda,
the run time (vector) for each lambda,
and the sequence of lambda used in the regression (vector)
}
\description{
\code{L2E_sparse_ncv} computes the solution path of robust sparse regression under the L2 criterion. Available penalties include lasso, MCP and SCAD.
}
\examples{
set.seed(12345)
n <- 100
tau <- 1
f <- matrix(c(rep(2,5), rep(0,45)), ncol = 1)
X <- X0 <- matrix(rnorm(n*50), nrow = n)
y <- y0 <- X0 \%*\% f + (1/tau)*rnorm(n)

## Clean Data
lambda <- 10^(-1)
sol <- L2E_sparse_ncv(y=y, X=X, lambdaSeq=lambda, penalty="SCAD")
r <- y - X \%*\% sol$Beta
ix <- which(abs(r) > 3/sol$Tau)
l2e_fit <- X \%*\% sol$Beta

plot(y, l2e_fit, ylab='Predicted values', pch=16, cex=0.8)
points(y[ix], l2e_fit[ix], pch=16, col='blue', cex=0.8)

## Contaminated Data
i <- 1:5
y[i] <- 2 + y0[i]
X[i,] <- 2 + X0[i,]

sol <- L2E_sparse_ncv(y=y, X=X, lambdaSeq=lambda, penalty="SCAD")
r <- y - X \%*\% sol$Beta
ix <- which(abs(r) > 3/sol$Tau)
l2e_fit <- X \%*\% sol$Beta

plot(y, l2e_fit, ylab='Predicted values', pch=16, cex=0.8)
points(y[ix], l2e_fit[ix], pch=16, col='blue', cex=0.8)

}
