% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_beta_MM_sparse.R
\name{update_beta_MM_sparse}
\alias{update_beta_MM_sparse}
\title{Beta update in L2E sparse regression - MM}
\usage{
update_beta_MM_sparse(
  y,
  X,
  beta,
  tau,
  k,
  rho,
  stepsize = 0.9,
  sigma = 0.5,
  max_iter = 100,
  tol = 1e-04
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix}

\item{beta}{Initial vector of regression coefficients}

\item{tau}{Initial precision estimate}

\item{k}{The number of nonzero entries in the estimated coefficients}

\item{rho}{The parameter in the proximal distance algorithm}

\item{stepsize}{The stepsize parameter for the MM algorithm (0, 1)}

\item{sigma}{The halving parameter sigma (0, 1)}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}
}
\value{
Returns a list object containing the new estimate for beta (vector) and the number of iterations (scalar) the update step utilized
}
\description{
\code{update_beta_MM_sparse} updates beta for L2E sparse regression using the distance penalty
}
