% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LKTfunctions.R
\name{predict_lkt}
\alias{predict_lkt}
\title{Predict for LKT Models}
\usage{
predict_lkt(
  modelob,
  data,
  fold = NULL,
  return_stats = FALSE,
  min_pred_limit = 1e-05,
  max_pred_limit = 0.99999
)
}
\arguments{
\item{modelob}{An LKT model object containing necessary model coefficients and predictors for generating predictions.}

\item{data}{A dataset including predictor variables, the outcome variable \code{CF..ansbin.}, and fold information.}

\item{fold}{Optional. Numeric vector specifying which folds to include for prediction. If NULL or empty, uses all data.}

\item{return_stats}{Logical. If TRUE, returns both predictions and evaluation statistics (Log-Likelihood, AUC, RMSE, R^2). If FALSE, returns only the predictions.}

\item{min_pred_limit}{Minimum prediction limit. Default is 0.00001.}

\item{max_pred_limit}{Maximum prediction limit. Default is 0.99999.}
}
\value{
If return_stats is FALSE, returns a list containing:
\itemize{
\item \code{predictions}: The predicted probabilities for each observation in the specified fold(s).
}
If return_stats is TRUE, returns a list containing:
\itemize{
\item \code{predictions}: The predicted probabilities for each observation in the specified fold(s).
\item \code{LL}: Log-Likelihood of the model given the actual outcomes.
\item \code{AUC}: Area Under the ROC Curve.
\item \code{RMSE}: Root Mean Squared Error.
\item \code{R2}: R-squared value, indicating the proportion of variance explained by the model.
}
}
\description{
Generates predictions and evaluates logistic regression models tailored for learning data, specifically designed for Logistic Knowledge Tracing (LKT) models. This function provides flexibility in returning either just the predicted probabilities or both the predictions and key evaluation statistics.
}
