% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DifferentiationCholesky.R
\name{ADchol}
\alias{ADchol}
\title{construct object for Automated Differentiation Cholesky decomposition}
\usage{
ADchol(lP)
}
\arguments{
\item{lP}{a list of symmetric matrices of class spam, each of dimension \eqn{q \times q},
and with sum of the matrices assumed to be positive definite.}
}
\value{
An object of class \code{ADchol}. This object is used to calculate the partial
partial derivatives of \eqn{log|C|} in an efficient way.
}
\description{
Construct object for reverse Automated Differentiation of Cholesky decomposition,
with as input a list of semi-positive symmetric sparse matrices \eqn{P_i}, each of
dimension \eqn{q \times q}. The function \code{ADchol} calculates the matrix \eqn{C}, the sum
the precision matrices \eqn{P_i}: \eqn{C = \sum_{i}  P_i}. Next, it calculates the Cholesky
Decomposition using the multiple minimum degree (MMD) algorithm
of the \code{spam} package.
}
\references{
Furrer, R., & Sain, S. R. (2010). spam: A sparse matrix R package with emphasis
on MCMC methods for Gaussian Markov random fields.
Journal of Statistical Software, 36, 1-25.
}
\keyword{internal}
