% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smu.R
\name{Smu}
\alias{Smu}
\title{Standard Deviation Estimator when the Population Mean is Known}
\usage{
Smu(x, mu)
}
\arguments{
\item{x}{a numeric vector containing the sample.}

\item{mu}{the population mean.}
}
\value{
A single numerical value corresponding with the standard deviation estimation when the population mean is known.
}
\description{
\code{Smu} computes a estimation of the standard deviation, given a sample \code{x} with known mean (denoted by \code{mu}).
}
\details{
Given \eqn{\{x_1,\ldots,x_n\}} a sample of a random variable, the standard deviation estimator
when the population mean (denoted by \eqn{\mu}) is known can be computed as \eqn{S_\mu=\sqrt{\frac{1}{n}\sum_{i=1}^n (x_i-\mu)^2}}.
}
\examples{
x=rnorm(20)
Smu(x,mu=0)
}
