% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{plotBeta}
\alias{plotBeta}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a Beta Distribution}
\usage{
plotBeta(shape1, shape2, type = "b", col = "black")
}
\arguments{
\item{shape1, shape2}{parameters of the Beta distribution (mean equal to \code{shape1}/(\code{shape1}+\code{shape2})}

\item{type}{a character string giving the type of plot desired. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotBeta} represents density, distribution and/or quantile functions associated with a Beta
 distribution with parameters \code{shape1} and \code{shape2}.
}
\examples{
shape1=1;shape2=1
plotBeta(shape1,shape2)
plotBeta(shape1,shape2,col="red")
plotBeta(shape1,shape2,type="q")
plotBeta(shape1,shape2,type="dis")
plotBeta(shape1,shape2,type="den")
}
