% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localControl.R
\name{plot.LocalControlCS}
\alias{plot.LocalControlCS}
\title{Plots the local treatment difference as a function of radius for LocalControl.}
\usage{
\method{plot}{LocalControlCS}(
  x,
  ...,
  nnConfidence,
  ylim,
  legendLocation = "bottomleft",
  ylab = "LTD",
  xlab = "Fraction of maximum radius",
  main = ""
)
}
\arguments{
\item{x}{Return object from LocalControl with "default" outcomeType.}

\item{...}{
  Arguments passed on to \code{\link[graphics:plot.default]{graphics::plot.default}}
  \describe{
    \item{\code{type}}{1-character string giving the type of plot desired.  The
    following values are possible, for details, see \code{\link[graphics]{plot}}:
    \code{"p"} for points, \code{"l"} for lines,
    \code{"b"} for both points and lines,
    \code{"c"} for empty points joined by lines,
    \code{"o"} for overplotted points and lines,
    \code{"s"} and \code{"S"} for stair steps and
    \code{"h"} for histogram-like vertical lines.  Finally,
    \code{"n"} does not produce any points or lines.}
    \item{\code{xlim}}{the x limits (x1, x2) of the plot.  Note that \code{x1 > x2}
    is allowed and leads to a \sQuote{reversed axis}.

    The default value, \code{NULL}, indicates that the range of the
    \link{finite} values to be plotted should be used.}
    \item{\code{log}}{a character string which contains \code{"x"} if the x axis
    is to be logarithmic, \code{"y"} if the y axis is to be logarithmic
    and \code{"xy"} or \code{"yx"} if both axes are to be logarithmic.}
    \item{\code{sub}}{a subtitle for the plot.}
    \item{\code{ann}}{a logical value indicating whether the default annotation
    (title and x and y axis labels) should appear on the plot.}
    \item{\code{axes}}{a logical value indicating whether both axes should be drawn on
    the plot.  Use \link[graphics]{graphical parameter} \code{"xaxt"} or \code{"yaxt"}
    to suppress just one of the axes.}
    \item{\code{frame.plot}}{a logical indicating whether a box should be drawn
    around the plot.}
    \item{\code{panel.first}}{an \sQuote{expression} to be evaluated after the
    plot axes are set up but before any plotting takes place.  This can
    be useful for drawing background grids or scatterplot smooths.  Note
    that this works by lazy evaluation: passing this argument from other
    \code{plot} methods may well not work since it may be evaluated too
    early.}
    \item{\code{panel.last}}{an expression to be evaluated after plotting has
    taken place but before the axes, title and box are added.  See the
    comments about \code{panel.first}.}
    \item{\code{asp}}{the \eqn{y/x} aspect ratio, see \code{\link[graphics]{plot.window}}.}
    \item{\code{xgap.axis,ygap.axis}}{the \eqn{x/y} axis gap factors, passed as
    \code{gap.axis} to the two \code{\link[graphics]{axis}()} calls (when
    \code{axes} is true, as per default).}
  }}

\item{nnConfidence}{Return object from LocalControlNearestNeighborsConfidence}

\item{ylim}{The y axis bounds. Defaults to c(0,1).}

\item{legendLocation}{The location to place the legend. Default "topleft".}

\item{ylab}{The y axis label. Defaults to "LTD".}

\item{xlab}{The x axis label. Defaults to "Fraction of maximum radius".}

\item{main}{The main plot title. Default is empty.}
}
\description{
Creates a plot where the y axis represents the local treatment difference,
while the x axis represents the percentage of the maximum radius. If the confidence summary (nnConfidence)
is provided, the 50\% and 95\% confidence estimates are also plotted.
}
\examples{
data(lindner)
# Specify clustering variables.
linVars <- c("stent", "height", "female", "diabetic",
             "acutemi", "ejecfrac", "ves1proc")

# Call Local Control once.
linRes <- LocalControl(data = lindner,
                       clusterVars = linVars,
                       treatmentColName = "abcix",
                       outcomeColName = "cardbill",
                       treatmentCode = 1)

# Plot the local treatment differences from Local Control without
# confidence intervals.
plot(linRes, ylim =  c(-6000, 3600))

#If the confidence intervals are calculated:
#linConfidence = LocalControlNearestNeighborsConfidence(
#                                      data = lindner,
#                                      clusterVars = linVars,
#                                      treatmentColName = "abcix",
#                                      outcomeColName = "cardbill",
#                                      treatmentCode = 1, nBootstrap = 100)

# Plot the local treatment difference with confidence intervals.
#plot(linRes, linConfidence)

}
\references{
\itemize{
   \item Lauve NR, Nelson SJ, Young SS, Obenchain RL, Lambert CG. LocalControl: An R Package for Comparative Safety and Effectiveness Research. Journal of Statistical Software. 2020. p. 1-32. Available from: http://dx.doi.org/10.18637/jss.v096.i04
}
}
